## Controller tuning exercise

### Step 1

Load the model [ControllerTuning.apros](http://www.simantics.org/~niemisto/SCL20150513/ControllerTuning.apros).

Run a sequence from SCL console that first sets the value of the set point (`SP01#SP_VALUE`) to 110,
then waits 10 seconds and stops.

::value[Apros/Sequences/runSequence,Simantics/Sequences/execute,Simantics/Sequences/setVar,Simantics/Sequences/wait,Simantics/Sequences/stop]

Open the chart and examine the results.

### Step 2

Put your sequence inside a function that takes the controller parameters
`PIC01#PI_GAIN` and `PIC01#PI_INTEGRATION_TIME` as a parameter and sets
them at the same time with the set point. It should also load the IC
before simulation with command

    loadInitialCondition (syncRead $ \_ -> fromResource $ relativeResource currentModel "/Initial%20Condition")

### Step 3

Create a separate simulation thread that computes the last time the flow speed
`XA01#ANALOG_VALUE` is within 1 from the set point value 110. Your function
should return that value. The following functions are useful for that:   

::value[Simantics/Sequences/getVar]
::value[Simantics/Sequences/fork]
::value[Prelude/repeatForever]

### Step 4

Try the optimization routine

::value[Simantics/Newuoa/bobyqa]

with function

    f [x,y] = let dx=x-1 ; dy=y-2 in dx*dx + dy*dy

### Step 5

Optimize the controller parameters using the objective function you created in step 3.

